@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperAttributeReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Attribute reference details for the referred column.
 * @property entity Name of the table.
 * @property entityConnectionReference The connection reference for the connection.
 * @property name Name of the column.
 */
public data class MapperAttributeReferenceArgs(
    public val entity: Output<String>? = null,
    public val entityConnectionReference: Output<MapperConnectionReferenceArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperAttributeReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperAttributeReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperAttributeReferenceArgs.builder()
            .entity(entity?.applyValue({ args0 -> args0 }))
            .entityConnectionReference(
                entityConnectionReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapperAttributeReferenceArgs].
 */
@PulumiTagMarker
public class MapperAttributeReferenceArgsBuilder internal constructor() {
    private var entity: Output<String>? = null

    private var entityConnectionReference: Output<MapperConnectionReferenceArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Name of the table.
     */
    @JvmName("njfqjekaqdwwywdt")
    public suspend fun entity(`value`: Output<String>) {
        this.entity = value
    }

    /**
     * @param value The connection reference for the connection.
     */
    @JvmName("uhuxecxlyedekmam")
    public suspend fun entityConnectionReference(`value`: Output<MapperConnectionReferenceArgs>) {
        this.entityConnectionReference = value
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("tfasggydprmocbvq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("xxkphfsaeplnrera")
    public suspend fun entity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entity = mapped
    }

    /**
     * @param value The connection reference for the connection.
     */
    @JvmName("ylsjollbijrguihp")
    public suspend fun entityConnectionReference(`value`: MapperConnectionReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityConnectionReference = mapped
    }

    /**
     * @param argument The connection reference for the connection.
     */
    @JvmName("qnmxmonyjgmupwnd")
    public suspend
    fun entityConnectionReference(argument: suspend MapperConnectionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = MapperConnectionReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.entityConnectionReference = mapped
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("peprcwblhfwyhspb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MapperAttributeReferenceArgs = MapperAttributeReferenceArgs(
        entity = entity,
        entityConnectionReference = entityConnectionReference,
        name = name,
    )
}
