@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperTargetConnectionsInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A object which contains list of tables and connection details for a target connection.
 * @property connection Source connection details.
 * @property dataMapperMappings List of table mappings.
 * @property relationships List of relationship info among the tables.
 * @property targetEntities List of source tables for a target connection.
 */
public data class MapperTargetConnectionsInfoArgs(
    public val connection: Output<MapperConnectionArgs>? = null,
    public val dataMapperMappings: Output<List<DataMapperMappingArgs>>? = null,
    public val relationships: Output<List<Any>>? = null,
    public val targetEntities: Output<List<MapperTableArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperTargetConnectionsInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperTargetConnectionsInfoArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperTargetConnectionsInfoArgs.builder()
            .connection(connection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataMapperMappings(
                dataMapperMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .relationships(relationships?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetEntities(
                targetEntities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperTargetConnectionsInfoArgs].
 */
@PulumiTagMarker
public class MapperTargetConnectionsInfoArgsBuilder internal constructor() {
    private var connection: Output<MapperConnectionArgs>? = null

    private var dataMapperMappings: Output<List<DataMapperMappingArgs>>? = null

    private var relationships: Output<List<Any>>? = null

    private var targetEntities: Output<List<MapperTableArgs>>? = null

    /**
     * @param value Source connection details.
     */
    @JvmName("ndeeciimnhebsjwb")
    public suspend fun connection(`value`: Output<MapperConnectionArgs>) {
        this.connection = value
    }

    /**
     * @param value List of table mappings.
     */
    @JvmName("rsvdbtdrtsdurrfj")
    public suspend fun dataMapperMappings(`value`: Output<List<DataMapperMappingArgs>>) {
        this.dataMapperMappings = value
    }

    @JvmName("ooxhojohpfjxvayv")
    public suspend fun dataMapperMappings(vararg values: Output<DataMapperMappingArgs>) {
        this.dataMapperMappings = Output.all(values.asList())
    }

    /**
     * @param values List of table mappings.
     */
    @JvmName("wfroxvfrobcdkmlv")
    public suspend fun dataMapperMappings(values: List<Output<DataMapperMappingArgs>>) {
        this.dataMapperMappings = Output.all(values)
    }

    /**
     * @param value List of relationship info among the tables.
     */
    @JvmName("sjvnvxnkpbntwbtc")
    public suspend fun relationships(`value`: Output<List<Any>>) {
        this.relationships = value
    }

    @JvmName("qnwkltykentxsowr")
    public suspend fun relationships(vararg values: Output<Any>) {
        this.relationships = Output.all(values.asList())
    }

    /**
     * @param values List of relationship info among the tables.
     */
    @JvmName("uttgnlwkuqbyenlq")
    public suspend fun relationships(values: List<Output<Any>>) {
        this.relationships = Output.all(values)
    }

    /**
     * @param value List of source tables for a target connection.
     */
    @JvmName("gffasjdlomjxgltd")
    public suspend fun targetEntities(`value`: Output<List<MapperTableArgs>>) {
        this.targetEntities = value
    }

    @JvmName("rdgeqcgjbtbofhcs")
    public suspend fun targetEntities(vararg values: Output<MapperTableArgs>) {
        this.targetEntities = Output.all(values.asList())
    }

    /**
     * @param values List of source tables for a target connection.
     */
    @JvmName("ptyhvsepxygwqtro")
    public suspend fun targetEntities(values: List<Output<MapperTableArgs>>) {
        this.targetEntities = Output.all(values)
    }

    /**
     * @param value Source connection details.
     */
    @JvmName("oonehodvxenijlai")
    public suspend fun connection(`value`: MapperConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connection = mapped
    }

    /**
     * @param argument Source connection details.
     */
    @JvmName("ljpwrbhicfhcgbnu")
    public suspend fun connection(argument: suspend MapperConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = MapperConnectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connection = mapped
    }

    /**
     * @param value List of table mappings.
     */
    @JvmName("ncetyraqsljcldlb")
    public suspend fun dataMapperMappings(`value`: List<DataMapperMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataMapperMappings = mapped
    }

    /**
     * @param argument List of table mappings.
     */
    @JvmName("rdqcvoakvevwdkay")
    public suspend
    fun dataMapperMappings(argument: List<suspend DataMapperMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataMapperMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataMapperMappings = mapped
    }

    /**
     * @param argument List of table mappings.
     */
    @JvmName("qvfpgriacqgksavt")
    public suspend fun dataMapperMappings(
        vararg
        argument: suspend DataMapperMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataMapperMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataMapperMappings = mapped
    }

    /**
     * @param argument List of table mappings.
     */
    @JvmName("vulbfqkrfkhdyyst")
    public suspend fun dataMapperMappings(argument: suspend DataMapperMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataMapperMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataMapperMappings = mapped
    }

    /**
     * @param values List of table mappings.
     */
    @JvmName("sedbmxtorchweolj")
    public suspend fun dataMapperMappings(vararg values: DataMapperMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataMapperMappings = mapped
    }

    /**
     * @param value List of relationship info among the tables.
     */
    @JvmName("youjrkhitmkqwfya")
    public suspend fun relationships(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationships = mapped
    }

    /**
     * @param values List of relationship info among the tables.
     */
    @JvmName("sqigllopmqqurbee")
    public suspend fun relationships(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relationships = mapped
    }

    /**
     * @param value List of source tables for a target connection.
     */
    @JvmName("fmcauktysvunhjnq")
    public suspend fun targetEntities(`value`: List<MapperTableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEntities = mapped
    }

    /**
     * @param argument List of source tables for a target connection.
     */
    @JvmName("lpyirophtpxaetkp")
    public suspend fun targetEntities(argument: List<suspend MapperTableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MapperTableArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targetEntities = mapped
    }

    /**
     * @param argument List of source tables for a target connection.
     */
    @JvmName("emcbufrjhebucrvk")
    public suspend fun targetEntities(vararg argument: suspend MapperTableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MapperTableArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targetEntities = mapped
    }

    /**
     * @param argument List of source tables for a target connection.
     */
    @JvmName("kuhkjkkrpvgqilek")
    public suspend fun targetEntities(argument: suspend MapperTableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MapperTableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetEntities = mapped
    }

    /**
     * @param values List of source tables for a target connection.
     */
    @JvmName("vdfssglforidlowj")
    public suspend fun targetEntities(vararg values: MapperTableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetEntities = mapped
    }

    internal fun build(): MapperTargetConnectionsInfoArgs = MapperTargetConnectionsInfoArgs(
        connection = connection,
        dataMapperMappings = dataMapperMappings,
        relationships = relationships,
        targetEntities = targetEntities,
    )
}
