@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MicrosoftAccessTableDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Microsoft Access table dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property tableName The Microsoft Access table name. Type: string (or Expression with resultType string).
 * @property type Type of dataset.
 * Expected value is 'MicrosoftAccessTable'.
 */
public data class MicrosoftAccessTableDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val tableName: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MicrosoftAccessTableDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MicrosoftAccessTableDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.MicrosoftAccessTableDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MicrosoftAccessTableDatasetArgs].
 */
@PulumiTagMarker
public class MicrosoftAccessTableDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var tableName: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("kuvyrrmjhjsnposa")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("elhgqrxfhkrflofu")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("xaspldvtidkmnexr")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("wnxumybspnduerqn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("pqqcskcqkuhpnlyq")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("mvcdixajptdeyydp")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("qagniaxjejirxbve")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("mlmtactmovjgpqao")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("jpuogepmtoucottk")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value The Microsoft Access table name. Type: string (or Expression with resultType string).
     */
    @JvmName("bghhsmykfqgkqgvh")
    public suspend fun tableName(`value`: Output<Any>) {
        this.tableName = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'MicrosoftAccessTable'.
     */
    @JvmName("gsbpofdkgmlrfbce")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("aswrdbopirloycnx")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("avijarldwymcqgmi")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("elfmykwmraufiivn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("kpttbftdwswgpfny")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("dlwyavrxfrujmveo")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("uyyrvlqkyuehmfnh")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("wokygyknpcnqwodr")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("mntfjvdmhmuoknfh")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("ahxjcxankpxeccko")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("nearcmihtqygepof")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("pykljkdnamamubir")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("pskfwqrxwxakksyj")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value The Microsoft Access table name. Type: string (or Expression with resultType string).
     */
    @JvmName("xgogcqqgoshdvyoo")
    public suspend fun tableName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'MicrosoftAccessTable'.
     */
    @JvmName("geyolrnyvlmfuywp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MicrosoftAccessTableDatasetArgs = MicrosoftAccessTableDatasetArgs(
        annotations = annotations,
        description = description,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        parameters = parameters,
        schema = schema,
        structure = structure,
        tableName = tableName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
