@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.OracleSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity Oracle source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property oracleReaderQuery Oracle reader query. Type: string (or Expression with resultType string).
 * @property partitionOption The partition mechanism that will be used for Oracle read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
 * @property partitionSettings The settings that will be leveraged for Oracle source partitioning.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'OracleSource'.
 */
public data class OracleSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val oracleReaderQuery: Output<Any>? = null,
    public val partitionOption: Output<Any>? = null,
    public val partitionSettings: Output<OraclePartitionSettingsArgs>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.OracleSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.OracleSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.OracleSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .oracleReaderQuery(oracleReaderQuery?.applyValue({ args0 -> args0 }))
            .partitionOption(partitionOption?.applyValue({ args0 -> args0 }))
            .partitionSettings(partitionSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OracleSourceArgs].
 */
@PulumiTagMarker
public class OracleSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var oracleReaderQuery: Output<Any>? = null

    private var partitionOption: Output<Any>? = null

    private var partitionSettings: Output<OraclePartitionSettingsArgs>? = null

    private var queryTimeout: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("vxvreimhsmilftom")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vyfbukoovttacujr")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bpybqhwgbaewvppx")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Oracle reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("iyrvvscxainkbcab")
    public suspend fun oracleReaderQuery(`value`: Output<Any>) {
        this.oracleReaderQuery = value
    }

    /**
     * @param value The partition mechanism that will be used for Oracle read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
     */
    @JvmName("ksubldabjhdgxejw")
    public suspend fun partitionOption(`value`: Output<Any>) {
        this.partitionOption = value
    }

    /**
     * @param value The settings that will be leveraged for Oracle source partitioning.
     */
    @JvmName("vfhhsjwsrifpgkvd")
    public suspend fun partitionSettings(`value`: Output<OraclePartitionSettingsArgs>) {
        this.partitionSettings = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("qjitfkibyuurevfa")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lxjsfaegsbsyjpoa")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("chymuktfdmtqwcyw")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'OracleSource'.
     */
    @JvmName("duckryrbwnxrroke")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("vgkegwotqtimhqvp")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("iimoxtyhyhbovmjl")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jnserdnwociifbxm")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Oracle reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("xquvbfksqrwhhvnn")
    public suspend fun oracleReaderQuery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oracleReaderQuery = mapped
    }

    /**
     * @param value The partition mechanism that will be used for Oracle read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
     */
    @JvmName("eaudicevukfpbhgl")
    public suspend fun partitionOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionOption = mapped
    }

    /**
     * @param value The settings that will be leveraged for Oracle source partitioning.
     */
    @JvmName("cuwpfgjcsbckiacf")
    public suspend fun partitionSettings(`value`: OraclePartitionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionSettings = mapped
    }

    /**
     * @param argument The settings that will be leveraged for Oracle source partitioning.
     */
    @JvmName("vvwanuycsjlfbusf")
    public suspend
    fun partitionSettings(argument: suspend OraclePartitionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = OraclePartitionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionSettings = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("oglreyxktgubapus")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("iyxfjrnebexevick")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("glkjyfeuoqmqpnnf")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'OracleSource'.
     */
    @JvmName("uhjxabqvbxbkukhq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OracleSourceArgs = OracleSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        oracleReaderQuery = oracleReaderQuery,
        partitionOption = partitionOption,
        partitionSettings = partitionSettings,
        queryTimeout = queryTimeout,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
