@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PowerQuerySinkMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Map Power Query mashup query to sink dataset(s).
 * @property dataflowSinks List of sinks mapped to Power Query mashup query.
 * @property queryName Name of the query in Power Query mashup document.
 */
public data class PowerQuerySinkMappingArgs(
    public val dataflowSinks: Output<List<PowerQuerySinkArgs>>? = null,
    public val queryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PowerQuerySinkMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PowerQuerySinkMappingArgs =
        com.pulumi.azurenative.datafactory.inputs.PowerQuerySinkMappingArgs.builder()
            .dataflowSinks(
                dataflowSinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryName(queryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PowerQuerySinkMappingArgs].
 */
@PulumiTagMarker
public class PowerQuerySinkMappingArgsBuilder internal constructor() {
    private var dataflowSinks: Output<List<PowerQuerySinkArgs>>? = null

    private var queryName: Output<String>? = null

    /**
     * @param value List of sinks mapped to Power Query mashup query.
     */
    @JvmName("idlhrtyafqumscdm")
    public suspend fun dataflowSinks(`value`: Output<List<PowerQuerySinkArgs>>) {
        this.dataflowSinks = value
    }

    @JvmName("ulviesihnbfovthf")
    public suspend fun dataflowSinks(vararg values: Output<PowerQuerySinkArgs>) {
        this.dataflowSinks = Output.all(values.asList())
    }

    /**
     * @param values List of sinks mapped to Power Query mashup query.
     */
    @JvmName("pybqjwaccgqwufyd")
    public suspend fun dataflowSinks(values: List<Output<PowerQuerySinkArgs>>) {
        this.dataflowSinks = Output.all(values)
    }

    /**
     * @param value Name of the query in Power Query mashup document.
     */
    @JvmName("wdcvikqjsfnrrvth")
    public suspend fun queryName(`value`: Output<String>) {
        this.queryName = value
    }

    /**
     * @param value List of sinks mapped to Power Query mashup query.
     */
    @JvmName("hpatrvosvlwwigbp")
    public suspend fun dataflowSinks(`value`: List<PowerQuerySinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataflowSinks = mapped
    }

    /**
     * @param argument List of sinks mapped to Power Query mashup query.
     */
    @JvmName("quplaqqrjjbyijch")
    public suspend fun dataflowSinks(argument: List<suspend PowerQuerySinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PowerQuerySinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataflowSinks = mapped
    }

    /**
     * @param argument List of sinks mapped to Power Query mashup query.
     */
    @JvmName("oyrlkhxgxjrubuyw")
    public suspend fun dataflowSinks(vararg argument: suspend PowerQuerySinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PowerQuerySinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataflowSinks = mapped
    }

    /**
     * @param argument List of sinks mapped to Power Query mashup query.
     */
    @JvmName("mbwppsxtwqthuwuf")
    public suspend fun dataflowSinks(argument: suspend PowerQuerySinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PowerQuerySinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataflowSinks = mapped
    }

    /**
     * @param values List of sinks mapped to Power Query mashup query.
     */
    @JvmName("iihtinucuapmrekf")
    public suspend fun dataflowSinks(vararg values: PowerQuerySinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataflowSinks = mapped
    }

    /**
     * @param value Name of the query in Power Query mashup document.
     */
    @JvmName("hwnfotebmcfrepcx")
    public suspend fun queryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryName = mapped
    }

    internal fun build(): PowerQuerySinkMappingArgs = PowerQuerySinkMappingArgs(
        dataflowSinks = dataflowSinks,
        queryName = queryName,
    )
}
