@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.QuickBooksLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * QuickBooks server linked service.
 * @property accessToken The access token for OAuth 1.0 authentication.
 * @property accessTokenSecret The access token secret for OAuth 1.0 authentication.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property companyId The company ID of the QuickBooks company to authorize.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property consumerKey The consumer key for OAuth 1.0 authentication.
 * @property consumerSecret The consumer secret for OAuth 1.0 authentication.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'QuickBooks'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 */
public data class QuickBooksLinkedServiceArgs(
    public val accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val accessTokenSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val annotations: Output<List<Any>>? = null,
    public val companyId: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionProperties: Output<Any>? = null,
    public val consumerKey: Output<Any>? = null,
    public val consumerSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val endpoint: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.QuickBooksLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.QuickBooksLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.QuickBooksLinkedServiceArgs.builder()
            .accessToken(
                accessToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .accessTokenSecret(
                accessTokenSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .companyId(companyId?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionProperties(connectionProperties?.applyValue({ args0 -> args0 }))
            .consumerKey(consumerKey?.applyValue({ args0 -> args0 }))
            .consumerSecret(
                consumerSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuickBooksLinkedServiceArgs].
 */
@PulumiTagMarker
public class QuickBooksLinkedServiceArgsBuilder internal constructor() {
    private var accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var accessTokenSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var annotations: Output<List<Any>>? = null

    private var companyId: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionProperties: Output<Any>? = null

    private var consumerKey: Output<Any>? = null

    private var consumerSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var endpoint: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    /**
     * @param value The access token for OAuth 1.0 authentication.
     */
    @JvmName("leuxjidndnhjptdn")
    public suspend
    fun accessToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessToken = value
    }

    /**
     * @param value The access token secret for OAuth 1.0 authentication.
     */
    @JvmName("fbajvynvuqqvvggs")
    public suspend
    fun accessTokenSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessTokenSecret = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("silkmxwiihtsvltm")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("uovlbmvhejypwiqq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("dkplxywmgsjgklku")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The company ID of the QuickBooks company to authorize.
     */
    @JvmName("gbdeqkciuikpaeil")
    public suspend fun companyId(`value`: Output<Any>) {
        this.companyId = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ijonaoipmmhrjxja")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("etffnrwpywrcosop")
    public suspend fun connectionProperties(`value`: Output<Any>) {
        this.connectionProperties = value
    }

    /**
     * @param value The consumer key for OAuth 1.0 authentication.
     */
    @JvmName("yftlxkoosdjjxgts")
    public suspend fun consumerKey(`value`: Output<Any>) {
        this.consumerKey = value
    }

    /**
     * @param value The consumer secret for OAuth 1.0 authentication.
     */
    @JvmName("pmpvqfngosvfgjvt")
    public suspend
    fun consumerSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.consumerSecret = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("akkdtonyjgwmnupb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("opernyacemyhbqic")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
     */
    @JvmName("yjmqfhqolchfgkja")
    public suspend fun endpoint(`value`: Output<Any>) {
        this.endpoint = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("yyclqwdyyqktehvp")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'QuickBooks'.
     */
    @JvmName("skwsbmwhslisyfqs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("rwgfovdvblbpivot")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value The access token for OAuth 1.0 authentication.
     */
    @JvmName("wivbrakttvijteyw")
    public suspend
    fun accessToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The access token for OAuth 1.0 authentication.
     */
    @JvmName("rvbbdmeucfocdgck")
    public fun accessToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The access token for OAuth 1.0 authentication.
     */
    @JvmName("fsbdnpqfrpsmuyas")
    public fun accessToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The access token secret for OAuth 1.0 authentication.
     */
    @JvmName("xkmmqyowieuewasw")
    public suspend
    fun accessTokenSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTokenSecret = mapped
    }

    /**
     * @param value The access token secret for OAuth 1.0 authentication.
     */
    @JvmName("viofsdfebfyksowi")
    public fun accessTokenSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessTokenSecret = mapped
    }

    /**
     * @param value The access token secret for OAuth 1.0 authentication.
     */
    @JvmName("ygsjdyqvtxgcsepf")
    public fun accessTokenSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessTokenSecret = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("kvnugvcxhbokmsmn")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("spicmlxbqtgexcfw")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The company ID of the QuickBooks company to authorize.
     */
    @JvmName("dxsaqcbdqglapipe")
    public suspend fun companyId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyId = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("yrigpakridrmrtrd")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ebipsqqvehcwnwis")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("rjolrbxlmpmnjqcm")
    public suspend fun connectionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param value The consumer key for OAuth 1.0 authentication.
     */
    @JvmName("tgugbdifinfrcwjp")
    public suspend fun consumerKey(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerKey = mapped
    }

    /**
     * @param value The consumer secret for OAuth 1.0 authentication.
     */
    @JvmName("nluhuteeqbsobisd")
    public suspend
    fun consumerSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerSecret = mapped
    }

    /**
     * @param value The consumer secret for OAuth 1.0 authentication.
     */
    @JvmName("epvevqsqsbcemggv")
    public fun consumerSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerSecret = mapped
    }

    /**
     * @param value The consumer secret for OAuth 1.0 authentication.
     */
    @JvmName("ipicxnrejsimobxc")
    public fun consumerSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerSecret = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("cmljrodywkdmbdev")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("yiweeueuqlkptycg")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
     */
    @JvmName("mskyghihthdymrad")
    public suspend fun endpoint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("pjvwllpfodqlmied")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("cdvyracjjduunipk")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ypmscuqgovppcvke")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'QuickBooks'.
     */
    @JvmName("stavyocrhqpylnsg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("qwctwauwvunswlpw")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    internal fun build(): QuickBooksLinkedServiceArgs = QuickBooksLinkedServiceArgs(
        accessToken = accessToken,
        accessTokenSecret = accessTokenSecret,
        annotations = annotations,
        companyId = companyId,
        connectVia = connectVia,
        connectionProperties = connectionProperties,
        consumerKey = consumerKey,
        consumerSecret = consumerSecret,
        description = description,
        encryptedCredential = encryptedCredential,
        endpoint = endpoint,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
    )
}
