@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RestSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Rest service source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: key value pairs (value should be string type).
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property httpRequestTimeout The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property paginationRules The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestInterval The time to await before sending next page request.
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'RestSource'.
 */
public data class RestSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val additionalHeaders: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val httpRequestTimeout: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val paginationRules: Output<Any>? = null,
    public val requestBody: Output<Any>? = null,
    public val requestInterval: Output<Any>? = null,
    public val requestMethod: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RestSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RestSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.RestSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .additionalHeaders(additionalHeaders?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .httpRequestTimeout(httpRequestTimeout?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .paginationRules(paginationRules?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0 }))
            .requestInterval(requestInterval?.applyValue({ args0 -> args0 }))
            .requestMethod(requestMethod?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestSourceArgs].
 */
@PulumiTagMarker
public class RestSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var additionalHeaders: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var httpRequestTimeout: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var paginationRules: Output<Any>? = null

    private var requestBody: Output<Any>? = null

    private var requestInterval: Output<Any>? = null

    private var requestMethod: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: key value pairs (value should be string type).
     */
    @JvmName("cpngculftxhxgsld")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
     */
    @JvmName("cymttjsnowexddyx")
    public suspend fun additionalHeaders(`value`: Output<Any>) {
        this.additionalHeaders = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lepjrafayiyradxy")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("tanjsuaerkeicivo")
    public suspend fun httpRequestTimeout(`value`: Output<Any>) {
        this.httpRequestTimeout = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("idyevjwovnhwpqim")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
     */
    @JvmName("gdmsgkwxselipmwa")
    public suspend fun paginationRules(`value`: Output<Any>) {
        this.paginationRules = value
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("fmssflnnpawxycyh")
    public suspend fun requestBody(`value`: Output<Any>) {
        this.requestBody = value
    }

    /**
     * @param value The time to await before sending next page request.
     */
    @JvmName("nhjjafbfswlljpha")
    public suspend fun requestInterval(`value`: Output<Any>) {
        this.requestInterval = value
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("fbvukwjnnjxtwppv")
    public suspend fun requestMethod(`value`: Output<Any>) {
        this.requestMethod = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kdthiyrpvvbhhdsm")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("rcffwliecxexpput")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'RestSource'.
     */
    @JvmName("ogvcyrerbtjxrcuy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: key value pairs (value should be string type).
     */
    @JvmName("yqenddgfewhqmugx")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
     */
    @JvmName("ffdyeetvxcuarxen")
    public suspend fun additionalHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("cyqoyvvgjvjjiyug")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("arcoaxhfxwgrbujo")
    public suspend fun httpRequestTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRequestTimeout = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dliiluitumtaufbt")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
     */
    @JvmName("qvdgdoyumdkicwoq")
    public suspend fun paginationRules(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paginationRules = mapped
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("vcsgfbqcpasblcdj")
    public suspend fun requestBody(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param value The time to await before sending next page request.
     */
    @JvmName("odeotfsffxaqpuka")
    public suspend fun requestInterval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestInterval = mapped
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("ujelxspeeihajudy")
    public suspend fun requestMethod(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMethod = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cqargommdrafbbyq")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("spgsrumwhkhpbhon")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'RestSource'.
     */
    @JvmName("vxlmmhlmjkcxmdej")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RestSourceArgs = RestSourceArgs(
        additionalColumns = additionalColumns,
        additionalHeaders = additionalHeaders,
        disableMetricsCollection = disableMetricsCollection,
        httpRequestTimeout = httpRequestTimeout,
        maxConcurrentConnections = maxConcurrentConnections,
        paginationRules = paginationRules,
        requestBody = requestBody,
        requestInterval = requestInterval,
        requestMethod = requestMethod,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
