@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.RetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Execution policy for an activity.
 * @property count Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property intervalInSeconds Interval between retries in seconds. Default is 30.
 */
public data class RetryPolicyArgs(
    public val count: Output<Any>? = null,
    public val intervalInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.RetryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.RetryPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.RetryPolicyArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetryPolicyArgs].
 */
@PulumiTagMarker
public class RetryPolicyArgsBuilder internal constructor() {
    private var count: Output<Any>? = null

    private var intervalInSeconds: Output<Int>? = null

    /**
     * @param value Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("kjcxywqygnxvxvlr")
    public suspend fun count(`value`: Output<Any>) {
        this.count = value
    }

    /**
     * @param value Interval between retries in seconds. Default is 30.
     */
    @JvmName("cfhgkogthrhvgoil")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("kwouabnllmvvrnbp")
    public suspend fun count(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Interval between retries in seconds. Default is 30.
     */
    @JvmName("pegixnkijciatdqh")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    internal fun build(): RetryPolicyArgs = RetryPolicyArgs(
        count = count,
        intervalInSeconds = intervalInSeconds,
    )
}
