@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SalesforceLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Salesforce.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property apiVersion The Salesforce API version used in ADF. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property environmentUrl The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password The password for Basic authentication of the Salesforce instance.
 * @property securityToken The security token is optional to remotely access Salesforce instance.
 * @property type Type of linked service.
 * Expected value is 'Salesforce'.
 * @property username The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
 */
public data class SalesforceLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val apiVersion: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val environmentUrl: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val securityToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SalesforceLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SalesforceLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SalesforceLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .environmentUrl(environmentUrl?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .securityToken(
                securityToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SalesforceLinkedServiceArgs].
 */
@PulumiTagMarker
public class SalesforceLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var apiVersion: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var environmentUrl: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var securityToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("nadfiubaftvsqutm")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("bbvvueuehjlobfvq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hixyrofktdqrraiw")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The Salesforce API version used in ADF. Type: string (or Expression with resultType string).
     */
    @JvmName("auplurokxmhkdhdp")
    public suspend fun apiVersion(`value`: Output<Any>) {
        this.apiVersion = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("fmgxhbjmbqcwxsjc")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ecndulflshhnjwoq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("uwtcxaendabquffy")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
     */
    @JvmName("vhusncohdauyffct")
    public suspend fun environmentUrl(`value`: Output<Any>) {
        this.environmentUrl = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ijlfysfsvwrvuklo")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password for Basic authentication of the Salesforce instance.
     */
    @JvmName("ccowsmoqfvqnkggj")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The security token is optional to remotely access Salesforce instance.
     */
    @JvmName("axhvxrilqgmderyq")
    public suspend
    fun securityToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.securityToken = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Salesforce'.
     */
    @JvmName("nuriblggmqxbwgvm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
     */
    @JvmName("rhivvppdubqnisvb")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("tjeylqmprbrbbeit")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("uibitgmvvcaukfrq")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The Salesforce API version used in ADF. Type: string (or Expression with resultType string).
     */
    @JvmName("tbbargabvoqfoetj")
    public suspend fun apiVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("upekcqgukxedgipr")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("cokshxgpnopriugy")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("acmseftokwsvqker")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("xfuvjgufwvqyhqqp")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
     */
    @JvmName("rblxkjwbmqlckeds")
    public suspend fun environmentUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentUrl = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("viyaerqevblmaifx")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("roepexopsqwjurjg")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("htkgnlihtupmqaxs")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password for Basic authentication of the Salesforce instance.
     */
    @JvmName("mgusarlyvxaesnvp")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password for Basic authentication of the Salesforce instance.
     */
    @JvmName("pwiqlwxclbjwfsqy")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password for Basic authentication of the Salesforce instance.
     */
    @JvmName("fowpnqdcorfqhnug")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The security token is optional to remotely access Salesforce instance.
     */
    @JvmName("dccilknnnpsvwwlf")
    public suspend
    fun securityToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param value The security token is optional to remotely access Salesforce instance.
     */
    @JvmName("smoacfoydixrrnfw")
    public fun securityToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param value The security token is optional to remotely access Salesforce instance.
     */
    @JvmName("hrodyajkaekfafxc")
    public fun securityToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Salesforce'.
     */
    @JvmName("veqbyelfqlhhrcvh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string).
     */
    @JvmName("aswpeeuapphweudr")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SalesforceLinkedServiceArgs = SalesforceLinkedServiceArgs(
        annotations = annotations,
        apiVersion = apiVersion,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        environmentUrl = environmentUrl,
        parameters = parameters,
        password = password,
        securityToken = securityToken,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
