@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapOdpSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity source for SAP ODP source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property extractionMode The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property projection Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property selection Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property subscriberProcess The subscriber process to manage the delta process. Type: string (or Expression with resultType string).
 * @property type Copy source type.
 * Expected value is 'SapOdpSource'.
 */
public data class SapOdpSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val extractionMode: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val projection: Output<Any>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val selection: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val subscriberProcess: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapOdpSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapOdpSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.SapOdpSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .extractionMode(extractionMode?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .projection(projection?.applyValue({ args0 -> args0 }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .selection(selection?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .subscriberProcess(subscriberProcess?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapOdpSourceArgs].
 */
@PulumiTagMarker
public class SapOdpSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var extractionMode: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var projection: Output<Any>? = null

    private var queryTimeout: Output<Any>? = null

    private var selection: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var subscriberProcess: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("wngfbmvakcsflnxw")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ovxshnmvvnbpbieh")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string).
     */
    @JvmName("urujrbkfgptpodrj")
    public suspend fun extractionMode(`value`: Output<Any>) {
        this.extractionMode = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cedjlxplxjvnneke")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects).
     */
    @JvmName("tcmraermbivxivdv")
    public suspend fun projection(`value`: Output<Any>) {
        this.projection = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("pogrtnephfnattai")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects).
     */
    @JvmName("qbdaybqdxmsjysjl")
    public suspend fun selection(`value`: Output<Any>) {
        this.selection = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("skxaloxrbsxpuual")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("nnmjqtlwqnpqioua")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value The subscriber process to manage the delta process. Type: string (or Expression with resultType string).
     */
    @JvmName("evjtkpnoybpcrybk")
    public suspend fun subscriberProcess(`value`: Output<Any>) {
        this.subscriberProcess = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapOdpSource'.
     */
    @JvmName("djjedtqmjngfomog")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("tvnpwoatxfsaljqw")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qgewnjxslwsfhgxo")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string).
     */
    @JvmName("ndgdrechjhrepkne")
    public suspend fun extractionMode(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extractionMode = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("huyxjpfruiqfkixw")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects).
     */
    @JvmName("lywjaiywejsmwipx")
    public suspend fun projection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projection = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("hegcjigtomkmbunv")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects).
     */
    @JvmName("ijtuckpxfbxtfuja")
    public suspend fun selection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selection = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("busejlnsvscdtvgl")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("wmkobuefsgdhfaln")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value The subscriber process to manage the delta process. Type: string (or Expression with resultType string).
     */
    @JvmName("eebixklxyshocqld")
    public suspend fun subscriberProcess(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberProcess = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapOdpSource'.
     */
    @JvmName("cjsorsumlfgrbftt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SapOdpSourceArgs = SapOdpSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        extractionMode = extractionMode,
        maxConcurrentConnections = maxConcurrentConnections,
        projection = projection,
        queryTimeout = queryTimeout,
        selection = selection,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        subscriberProcess = subscriberProcess,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
