@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ServicePrincipalCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Service principal credential.
 * @property annotations List of tags that can be used for describing the Credential.
 * @property description Credential description.
 * @property servicePrincipalId The app ID of the service principal used to authenticate
 * @property servicePrincipalKey The key of the service principal used to authenticate.
 * @property tenant The ID of the tenant to which the service principal belongs
 * @property type Type of credential.
 * Expected value is 'ServicePrincipal'.
 */
public data class ServicePrincipalCredentialArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ServicePrincipalCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ServicePrincipalCredentialArgs =
        com.pulumi.azurenative.datafactory.inputs.ServicePrincipalCredentialArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalCredentialArgs].
 */
@PulumiTagMarker
public class ServicePrincipalCredentialArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("nbmmoankheemsodl")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("lqosjclferdhbunb")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("tqeksjipokdrwgww")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Credential description.
     */
    @JvmName("viqloqoqphnxxepq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The app ID of the service principal used to authenticate
     */
    @JvmName("uyjfyxwycnvxnelk")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate.
     */
    @JvmName("bydnklqceyyhxxbr")
    public suspend fun servicePrincipalKey(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The ID of the tenant to which the service principal belongs
     */
    @JvmName("wlxjtaahdwfplysx")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of credential.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("cqncpyuqikidvtat")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("qbipoymrnsyrhclh")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("vovyipwackxthpye")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Credential description.
     */
    @JvmName("ihiyoauyrjjdrfbr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The app ID of the service principal used to authenticate
     */
    @JvmName("wdtwvrvqpeupwdjq")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate.
     */
    @JvmName("kjeaaybadyfdqnlp")
    public suspend fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param argument The key of the service principal used to authenticate.
     */
    @JvmName("mwugbochkjqrnptj")
    public suspend
    fun servicePrincipalKey(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The ID of the tenant to which the service principal belongs
     */
    @JvmName("lbgayjilkojjvfvw")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of credential.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("vtlwwolrjjigajtd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePrincipalCredentialArgs = ServicePrincipalCredentialArgs(
        annotations = annotations,
        description = description,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
