@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ShopifyLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Shopify Service linked service.
 * @property accessToken The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The endpoint of the Shopify server. (i.e. mystore.myshopify.com)
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'Shopify'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class ShopifyLinkedServiceArgs(
    public val accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
    public val useHostVerification: Output<Any>? = null,
    public val usePeerVerification: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ShopifyLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ShopifyLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.ShopifyLinkedServiceArgs.builder()
            .accessToken(
                accessToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 }))
            .useHostVerification(useHostVerification?.applyValue({ args0 -> args0 }))
            .usePeerVerification(usePeerVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShopifyLinkedServiceArgs].
 */
@PulumiTagMarker
public class ShopifyLinkedServiceArgsBuilder internal constructor() {
    private var accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    private var useHostVerification: Output<Any>? = null

    private var usePeerVerification: Output<Any>? = null

    /**
     * @param value The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
     */
    @JvmName("yxcxxxeqitpeutjy")
    public suspend
    fun accessToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessToken = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("eulpqqxrelwxpoqj")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("hgtrstaqwrxuokpa")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("yolfphnoxxfiytkp")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("jydkoquyddbdgucc")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("togyvixocfxanvgo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("iwiwrlqfrysgmyuh")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of the Shopify server. (i.e. mystore.myshopify.com)
     */
    @JvmName("plivsfxgddvidghy")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ymtmpdfthitrkjoy")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Shopify'.
     */
    @JvmName("nmlwnjkwxcbcccje")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("dbyplrhjynyxbydv")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("jpwfaovqwqpthioh")
    public suspend fun useHostVerification(`value`: Output<Any>) {
        this.useHostVerification = value
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("jaiubwrbjbaujfvb")
    public suspend fun usePeerVerification(`value`: Output<Any>) {
        this.usePeerVerification = value
    }

    /**
     * @param value The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
     */
    @JvmName("fwlrkunwvikbnrju")
    public suspend
    fun accessToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
     */
    @JvmName("puvkaftakgrxydwm")
    public fun accessToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The API access token that can be used to access Shopify’s data. The token won't expire if it is offline mode.
     */
    @JvmName("dllaovswvgtodgnu")
    public fun accessToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ulsprhkxcpufxxta")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("mwhdqdpgnpfavcuy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("iwtriivgosonovuu")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("jjwnvjtmmcmnbqvt")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("oxyvhaqknihrdmxo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("eybqbpraqfgqxcfl")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of the Shopify server. (i.e. mystore.myshopify.com)
     */
    @JvmName("eysxrbcyndadckeb")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("gqsipycmptlgaldp")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("otmrfncfdptcrcqf")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("pgtvxoduxetcnfbe")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Shopify'.
     */
    @JvmName("qxjakknelxcbltqt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("gnwnoxjrosdkxlrv")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("haloibolerwubkmm")
    public suspend fun useHostVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHostVerification = mapped
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("aukbfmocguahkqyq")
    public suspend fun usePeerVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePeerVerification = mapped
    }

    internal fun build(): ShopifyLinkedServiceArgs = ShopifyLinkedServiceArgs(
        accessToken = accessToken,
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
        useHostVerification = useHostVerification,
        usePeerVerification = usePeerVerification,
    )
}
