@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlDWUpsertSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sql DW upsert option settings
 * @property interimSchemaName Schema name for interim table. Type: string (or Expression with resultType string).
 * @property keys Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
 */
public data class SqlDWUpsertSettingsArgs(
    public val interimSchemaName: Output<Any>? = null,
    public val keys: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlDWUpsertSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlDWUpsertSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlDWUpsertSettingsArgs.builder()
            .interimSchemaName(interimSchemaName?.applyValue({ args0 -> args0 }))
            .keys(keys?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlDWUpsertSettingsArgs].
 */
@PulumiTagMarker
public class SqlDWUpsertSettingsArgsBuilder internal constructor() {
    private var interimSchemaName: Output<Any>? = null

    private var keys: Output<Any>? = null

    /**
     * @param value Schema name for interim table. Type: string (or Expression with resultType string).
     */
    @JvmName("ovobvrdsgpnraffx")
    public suspend fun interimSchemaName(`value`: Output<Any>) {
        this.interimSchemaName = value
    }

    /**
     * @param value Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("xyflrnuvftaaaavm")
    public suspend fun keys(`value`: Output<Any>) {
        this.keys = value
    }

    /**
     * @param value Schema name for interim table. Type: string (or Expression with resultType string).
     */
    @JvmName("ycvhtfuickugsbxc")
    public suspend fun interimSchemaName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interimSchemaName = mapped
    }

    /**
     * @param value Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("sbdseqwgsliyitsy")
    public suspend fun keys(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): SqlDWUpsertSettingsArgs = SqlDWUpsertSettingsArgs(
        interimSchemaName = interimSchemaName,
        keys = keys,
    )
}
