@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.UserAssignedManagedIdentityCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * User Assigned Managed identity credential.
 * @property annotations List of tags that can be used for describing the Credential.
 * @property description Credential description.
 * @property type Type of credential.
 * Expected value is 'UserAssignedManagedIdentityCredential'.
 */
public data class UserAssignedManagedIdentityCredentialArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.UserAssignedManagedIdentityCredentialArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.UserAssignedManagedIdentityCredentialArgs =
        com.pulumi.azurenative.datafactory.inputs.UserAssignedManagedIdentityCredentialArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedManagedIdentityCredentialArgs].
 */
@PulumiTagMarker
public class UserAssignedManagedIdentityCredentialArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("ddlktjmiabxxdgbb")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("xrkddhjhfvprgqtj")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("jysyvpdfrskrfpct")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Credential description.
     */
    @JvmName("bhgabhtqqhiyygbv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Type of credential.
     * Expected value is 'UserAssignedManagedIdentityCredential'.
     */
    @JvmName("aotnxtkfrqsrjlxl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("lkiqakcbdsknspfh")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("exvqhqsgnnbtnlnr")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Credential description.
     */
    @JvmName("rgrfxwmbqbdtdquo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Type of credential.
     * Expected value is 'UserAssignedManagedIdentityCredential'.
     */
    @JvmName("wddxxmibguxuwwwl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UserAssignedManagedIdentityCredentialArgs =
        UserAssignedManagedIdentityCredentialArgs(
            annotations = annotations,
            description = description,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
