@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WarehouseLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Microsoft Fabric Warehouse linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property artifactId The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The Key of the application used to authenticate against Microsoft Fabric Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Warehouse'.
 * @property workspaceId The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string).
 */
public data class WarehouseLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val artifactId: Output<Any>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val endpoint: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val servicePrincipalCredential:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalCredentialType: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
    public val workspaceId: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WarehouseLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WarehouseLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.WarehouseLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .artifactId(artifactId.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .servicePrincipalCredential(
                servicePrincipalCredential?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalCredentialType(servicePrincipalCredentialType?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WarehouseLinkedServiceArgs].
 */
@PulumiTagMarker
public class WarehouseLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var artifactId: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var endpoint: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var servicePrincipalCredential:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalCredentialType: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    private var workspaceId: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("rcrywwihtmmsmkum")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("bcsscesalyemtjff")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("exgiylrpdlsdwhan")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string).
     */
    @JvmName("eijisqwgtlvirmbv")
    public suspend fun artifactId(`value`: Output<Any>) {
        this.artifactId = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("rdobqntmjhnjvsqb")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("sijhsxdwixgixeay")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("yhukgffxbutlujmq")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string).
     */
    @JvmName("exocioftbrpliwci")
    public suspend fun endpoint(`value`: Output<Any>) {
        this.endpoint = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("emwishxwwncvxvxt")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("jvlstnbbmsonqkay")
    public suspend
    fun servicePrincipalCredential(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalCredential = value
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("pwqdniepqjcdykqh")
    public suspend fun servicePrincipalCredentialType(`value`: Output<Any>) {
        this.servicePrincipalCredentialType = value
    }

    /**
     * @param value The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("wypvchnmqufpfhip")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The Key of the application used to authenticate against Microsoft Fabric Warehouse.
     */
    @JvmName("pnktxlqwtkoqwhxn")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("otekbagdyvfsqxkp")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Warehouse'.
     */
    @JvmName("afxnyyjfypnltefu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string).
     */
    @JvmName("hlpdjgbuncujjppe")
    public suspend fun workspaceId(`value`: Output<Any>) {
        this.workspaceId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("rxrgmrtbbffaomyk")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("memafuouspiuarrf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string).
     */
    @JvmName("jdytkksucmpimgbh")
    public suspend fun artifactId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactId = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("lkgbhxbhxihmvawt")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("slhifatjfgeqwfqj")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("eslxfldtuvfxsjjb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("wgynarhuubllodeq")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string).
     */
    @JvmName("pisebdlfitcdvaua")
    public suspend fun endpoint(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("rbtqycngnjcfpqjq")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("qaxnsvqgnbqpcvjx")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("xpysqmyhcwmjxbyn")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("lfddqdpyccisiirc")
    public suspend
    fun servicePrincipalCredential(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("qhtvsukrofwjxbwo")
    public fun servicePrincipalCredential(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("artmjqrswmnpwtrm")
    public fun servicePrincipalCredential(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("lecrekdhvjmltkjy")
    public suspend fun servicePrincipalCredentialType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredentialType = mapped
    }

    /**
     * @param value The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("axljpoexyeagkuoo")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against Microsoft Fabric Warehouse.
     */
    @JvmName("krejkysxntvrkjqc")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against Microsoft Fabric Warehouse.
     */
    @JvmName("pipdvxpycvifsfbr")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against Microsoft Fabric Warehouse.
     */
    @JvmName("iejgqpsabqsutddg")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("iegacefdhsgwufku")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Warehouse'.
     */
    @JvmName("liqgnorrxejpolnk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string).
     */
    @JvmName("vqkbqhkhwagpscyb")
    public suspend fun workspaceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WarehouseLinkedServiceArgs = WarehouseLinkedServiceArgs(
        annotations = annotations,
        artifactId = artifactId ?: throw PulumiNullFieldException("artifactId"),
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        parameters = parameters,
        servicePrincipalCredential = servicePrincipalCredential,
        servicePrincipalCredentialType = servicePrincipalCredentialType,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
        workspaceId = workspaceId,
    )
}
