@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebClientCertificateAuthenticationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A WebLinkedService that uses client certificate based authentication to communicate with an HTTP endpoint. This scheme follows mutual authentication; the server must also provide valid credentials to the client.
 * @property authenticationType Type of authentication used to connect to the web table source.
 * Expected value is 'ClientCertificate'.
 * @property password Password for the PFX file.
 * @property pfx Base64-encoded contents of a PFX file.
 * @property url The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
 */
public data class WebClientCertificateAuthenticationArgs(
    public val authenticationType: Output<String>,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val pfx: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val url: Output<Any>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebClientCertificateAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.WebClientCertificateAuthenticationArgs =
        com.pulumi.azurenative.datafactory.inputs.WebClientCertificateAuthenticationArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .pfx(
                pfx.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebClientCertificateAuthenticationArgs].
 */
@PulumiTagMarker
public class WebClientCertificateAuthenticationArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var pfx: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var url: Output<Any>? = null

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'ClientCertificate'.
     */
    @JvmName("bejndgsckjfiysac")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Password for the PFX file.
     */
    @JvmName("fxpxomholuemdgbl")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Base64-encoded contents of a PFX file.
     */
    @JvmName("ksxwfthnoulwfcrq")
    public suspend
    fun pfx(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.pfx = value
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("ucvqipuiebhflwvy")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value Type of authentication used to connect to the web table source.
     * Expected value is 'ClientCertificate'.
     */
    @JvmName("jcjppuyyejxnxrjm")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Password for the PFX file.
     */
    @JvmName("qjhatnasarhuqcja")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for the PFX file.
     */
    @JvmName("ksqqxgsxtwiuweks")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for the PFX file.
     */
    @JvmName("lkrwqkotusgixkql")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file.
     */
    @JvmName("ipwehdgoheaahojd")
    public suspend fun pfx(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file.
     */
    @JvmName("mhqhagwmlbhhwool")
    public fun pfx(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Base64-encoded contents of a PFX file.
     */
    @JvmName("uextwytiviwubgsw")
    public fun pfx(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JvmName("hhmhdhfaovniywrv")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): WebClientCertificateAuthenticationArgs =
        WebClientCertificateAuthenticationArgs(
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            password = password ?: throw PulumiNullFieldException("password"),
            pfx = pfx ?: throw PulumiNullFieldException("pfx"),
            url = url ?: throw PulumiNullFieldException("url"),
        )
}
