@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity source for web page table.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'WebSource'.
 */
public data class WebSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.WebSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebSourceArgs].
 */
@PulumiTagMarker
public class WebSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("gtremnygiylssmeu")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jitjnkwwljlqymug")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qsmxrspjcmivrcpm")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fejqpabfskggvofa")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("sankogliibniqwqh")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'WebSource'.
     */
    @JvmName("hqarskibyfvrpxgw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("qbifatqkkccnffbc")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("usqrfytubochujql")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ybcmjcwxcavgstiy")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lowwembxfrskqyji")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ymntiwdjccnouwis")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'WebSource'.
     */
    @JvmName("fqqwfmydtkjlomsy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebSourceArgs = WebSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
