@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ZipDeflateReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ZipDeflate compression read settings.
 * @property preserveZipFileNameAsFolder Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean).
 * @property type The Compression setting type.
 * Expected value is 'ZipDeflateReadSettings'.
 */
public data class ZipDeflateReadSettingsArgs(
    public val preserveZipFileNameAsFolder: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ZipDeflateReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ZipDeflateReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.ZipDeflateReadSettingsArgs.builder()
            .preserveZipFileNameAsFolder(preserveZipFileNameAsFolder?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZipDeflateReadSettingsArgs].
 */
@PulumiTagMarker
public class ZipDeflateReadSettingsArgsBuilder internal constructor() {
    private var preserveZipFileNameAsFolder: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mwqeqowkxkercypu")
    public suspend fun preserveZipFileNameAsFolder(`value`: Output<Any>) {
        this.preserveZipFileNameAsFolder = value
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'ZipDeflateReadSettings'.
     */
    @JvmName("syyeauciubhiulbc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("colkkcamlktpygsn")
    public suspend fun preserveZipFileNameAsFolder(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveZipFileNameAsFolder = mapped
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'ZipDeflateReadSettings'.
     */
    @JvmName("xoblrilyechjvaxw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ZipDeflateReadSettingsArgs = ZipDeflateReadSettingsArgs(
        preserveZipFileNameAsFolder = preserveZipFileNameAsFolder,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
