@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Execution policy for an activity.
 * @property retry Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property retryIntervalInSeconds Interval between each retry attempt (in seconds). The default is 30 sec.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 * @property secureOutput When set to true, Output from activity is considered as secure and will not be logged to monitoring.
 * @property timeout Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class ActivityPolicyResponse(
    public val retry: Any? = null,
    public val retryIntervalInSeconds: Int? = null,
    public val secureInput: Boolean? = null,
    public val secureOutput: Boolean? = null,
    public val timeout: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ActivityPolicyResponse):
            ActivityPolicyResponse = ActivityPolicyResponse(
            retry = javaType.retry().map({ args0 -> args0 }).orElse(null),
            retryIntervalInSeconds = javaType.retryIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            secureInput = javaType.secureInput().map({ args0 -> args0 }).orElse(null),
            secureOutput = javaType.secureOutput().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
