@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Data Lake Store linked service.
 * @property accountName Data Lake Store account name. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property dataLakeStoreUri Data Lake Store service URI. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property resourceGroupName Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The Key of the application used to authenticate against the Azure Data Lake Store account.
 * @property subscriptionId Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureDataLakeStore'.
 */
public data class AzureDataLakeStoreLinkedServiceResponse(
    public val accountName: Any? = null,
    public val annotations: List<Any>? = null,
    public val azureCloudType: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val dataLakeStoreUri: Any,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val resourceGroupName: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val subscriptionId: Any? = null,
    public val tenant: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDataLakeStoreLinkedServiceResponse):
            AzureDataLakeStoreLinkedServiceResponse = AzureDataLakeStoreLinkedServiceResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            azureCloudType = javaType.azureCloudType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataLakeStoreUri = javaType.dataLakeStoreUri(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
