@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The azure table storage linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property type Type of linked service.
 * Expected value is 'AzureTableStorage'.
 */
public data class AzureTableStorageLinkedServiceResponse(
    public val accountKey: AzureKeyVaultSecretReferenceResponse? = null,
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionString: Any? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val sasToken: AzureKeyVaultSecretReferenceResponse? = null,
    public val sasUri: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureTableStorageLinkedServiceResponse):
            AzureTableStorageLinkedServiceResponse = AzureTableStorageLinkedServiceResponse(
            accountKey = javaType.accountKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            sasToken = javaType.sasToken().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasUri = javaType.sasUri().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
