@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed Identity used for CMK.
 * @property userAssignedIdentity The resource id of the user assigned identity to authenticate to customer's key vault.
 */
public data class CMKIdentityDefinitionResponse(
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CMKIdentityDefinitionResponse):
            CMKIdentityDefinitionResponse = CMKIdentityDefinitionResponse(
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
