@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Custom activity type.
 * @property autoUserSpecification Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
 * @property command Command for custom activity Type: string (or Expression with resultType string).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property extendedProperties User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
 * @property folderPath Folder path for resource files Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property referenceObjects Reference objects
 * @property resourceLinkedService Resource linked service reference.
 * @property retentionTimeInDays The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Custom'.
 * @property userProperties Activity user properties.
 */
public data class CustomActivityResponse(
    public val autoUserSpecification: Any? = null,
    public val command: Any,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val extendedProperties: Map<String, Any>? = null,
    public val folderPath: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val referenceObjects: CustomActivityReferenceObjectResponse? = null,
    public val resourceLinkedService: LinkedServiceReferenceResponse? = null,
    public val retentionTimeInDays: Any? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CustomActivityResponse):
            CustomActivityResponse = CustomActivityResponse(
            autoUserSpecification = javaType.autoUserSpecification().map({ args0 -> args0 }).orElse(null),
            command = javaType.command(),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            referenceObjects = javaType.referenceObjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CustomActivityReferenceObjectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceLinkedService = javaType.resourceLinkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionTimeInDays = javaType.retentionTimeInDays().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
