@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Delimited text write settings.
 * @property fileExtension The file extension used to create the files. Type: string (or Expression with resultType string).
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property quoteAllText Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
 * @property type The write setting type.
 * Expected value is 'DelimitedTextWriteSettings'.
 */
public data class DelimitedTextWriteSettingsResponse(
    public val fileExtension: Any,
    public val fileNamePrefix: Any? = null,
    public val maxRowsPerFile: Any? = null,
    public val quoteAllText: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DelimitedTextWriteSettingsResponse):
            DelimitedTextWriteSettingsResponse = DelimitedTextWriteSettingsResponse(
            fileExtension = javaType.fileExtension(),
            fileNamePrefix = javaType.fileNamePrefix().map({ args0 -> args0 }).orElse(null),
            maxRowsPerFile = javaType.maxRowsPerFile().map({ args0 -> args0 }).orElse(null),
            quoteAllText = javaType.quoteAllText().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
