@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Factory's VSTS repo information.
 * @property accountName Account name.
 * @property collaborationBranch Collaboration branch.
 * @property disablePublish Disable manual publish operation in ADF studio to favor automated publish.
 * @property lastCommitId Last commit id.
 * @property projectName VSTS project name.
 * @property repositoryName Repository name.
 * @property rootFolder Root folder.
 * @property tenantId VSTS tenant id.
 * @property type Type of repo configuration.
 * Expected value is 'FactoryVSTSConfiguration'.
 */
public data class FactoryVSTSConfigurationResponse(
    public val accountName: String,
    public val collaborationBranch: String,
    public val disablePublish: Boolean? = null,
    public val lastCommitId: String? = null,
    public val projectName: String,
    public val repositoryName: String,
    public val rootFolder: String,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FactoryVSTSConfigurationResponse):
            FactoryVSTSConfigurationResponse = FactoryVSTSConfigurationResponse(
            accountName = javaType.accountName(),
            collaborationBranch = javaType.collaborationBranch(),
            disablePublish = javaType.disablePublish().map({ args0 -> args0 }).orElse(null),
            lastCommitId = javaType.lastCommitId().map({ args0 -> args0 }).orElse(null),
            projectName = javaType.projectName(),
            repositoryName = javaType.repositoryName(),
            rootFolder = javaType.rootFolder(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
