@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed identity credential.
 * @property annotations List of tags that can be used for describing the Credential.
 * @property description Credential description.
 * @property type Type of credential.
 * Expected value is 'ManagedIdentity'.
 */
public data class ManagedIdentityCredentialResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedIdentityCredentialResponse):
            ManagedIdentityCredentialResponse = ManagedIdentityCredentialResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
