@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of integration runtime node.
 * @property errors The errors that occurred on this integration runtime node.
 * @property nodeId The managed integration runtime node id.
 * @property status The managed integration runtime node status.
 */
public data class ManagedIntegrationRuntimeNodeResponse(
    public val errors: List<ManagedIntegrationRuntimeErrorResponse>? = null,
    public val nodeId: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedIntegrationRuntimeNodeResponse):
            ManagedIntegrationRuntimeNodeResponse = ManagedIntegrationRuntimeNodeResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeErrorResponse.Companion.toKotlin(args0)
                })
            }),
            nodeId = javaType.nodeId(),
            status = javaType.status(),
        )
    }
}
