@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Attribute reference details for the referred column.
 * @property entity Name of the table.
 * @property entityConnectionReference The connection reference for the connection.
 * @property name Name of the column.
 */
public data class MapperAttributeReferenceResponse(
    public val entity: String? = null,
    public val entityConnectionReference: MapperConnectionReferenceResponse? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperAttributeReferenceResponse):
            MapperAttributeReferenceResponse = MapperAttributeReferenceResponse(
            entity = javaType.entity().map({ args0 -> args0 }).orElse(null),
            entityConnectionReference = javaType.entityConnectionReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperConnectionReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
