@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity source for an Office 365 service.
 * @property allowedGroups The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
 * @property dateFilterColumn The Column to apply the <paramref name="StartTime"/> and <paramref name="EndTime"/>. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property endTime End time of the requested range for this dataset. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property outputColumns The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn. Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property startTime Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
 * @property type Copy source type.
 * Expected value is 'Office365Source'.
 * @property userScopeFilterUri The user scope uri. Type: string (or Expression with resultType string).
 */
public data class Office365SourceResponse(
    public val allowedGroups: Any? = null,
    public val dateFilterColumn: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val endTime: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val outputColumns: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val startTime: Any? = null,
    public val type: String,
    public val userScopeFilterUri: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.Office365SourceResponse):
            Office365SourceResponse = Office365SourceResponse(
            allowedGroups = javaType.allowedGroups().map({ args0 -> args0 }).orElse(null),
            dateFilterColumn = javaType.dateFilterColumn().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            outputColumns = javaType.outputColumns().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userScopeFilterUri = javaType.userScopeFilterUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
