@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Definition of a single parameter for an entity.
 * @property defaultValue Default value of parameter.
 * @property type Parameter type.
 */
public data class ParameterSpecificationResponse(
    public val defaultValue: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ParameterSpecificationResponse):
            ParameterSpecificationResponse = ParameterSpecificationResponse(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
