@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * PipelineExternalComputeScale properties for managed integration runtime.
 * @property numberOfExternalNodes Number of the the external nodes, which should be greater than 0 and less than 11.
 * @property numberOfPipelineNodes Number of the pipeline nodes, which should be greater than 0 and less than 11.
 * @property timeToLive Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
 */
public data class PipelineExternalComputeScalePropertiesResponse(
    public val numberOfExternalNodes: Int? = null,
    public val numberOfPipelineNodes: Int? = null,
    public val timeToLive: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PipelineExternalComputeScalePropertiesResponse):
            PipelineExternalComputeScalePropertiesResponse =
            PipelineExternalComputeScalePropertiesResponse(
                numberOfExternalNodes = javaType.numberOfExternalNodes().map({ args0 -> args0 }).orElse(null),
                numberOfPipelineNodes = javaType.numberOfPipelineNodes().map({ args0 -> args0 }).orElse(null),
                timeToLive = javaType.timeToLive().map({ args0 -> args0 }).orElse(null),
            )
    }
}
