@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Rest Service linked service.
 * @property aadResourceId The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authHeaders The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType object).
 * @property authenticationType Type of authentication used to connect to the REST service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property clientId The client ID associated with your application. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret associated with your application.
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property enableServerCertificateValidation Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The password used in Basic authentication type.
 * @property resource The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
 * @property scope The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The application's key used in AadServicePrincipal authentication type.
 * @property tenant The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides. Type: string (or Expression with resultType string).
 * @property tokenEndpoint The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'RestService'.
 * @property url The base URL of the REST service. Type: string (or Expression with resultType string).
 * @property userName The user name used in Basic authentication type. Type: string (or Expression with resultType string).
 */
public data class RestServiceLinkedServiceResponse(
    public val aadResourceId: Any? = null,
    public val annotations: List<Any>? = null,
    public val authHeaders: Any? = null,
    public val authenticationType: String,
    public val azureCloudType: Any? = null,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val description: String? = null,
    public val enableServerCertificateValidation: Any? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val resource: Any? = null,
    public val scope: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val tenant: Any? = null,
    public val tokenEndpoint: Any? = null,
    public val type: String,
    public val url: Any,
    public val userName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RestServiceLinkedServiceResponse):
            RestServiceLinkedServiceResponse = RestServiceLinkedServiceResponse(
            aadResourceId = javaType.aadResourceId().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authHeaders = javaType.authHeaders().map({ args0 -> args0 }).orElse(null),
            authenticationType = javaType.authenticationType(),
            azureCloudType = javaType.azureCloudType().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enableServerCertificateValidation = javaType.enableServerCertificateValidation().map({ args0 ->
                args0
            }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
