@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Suppress

/**
 * SSIS access credential.
 * @property domain Domain for windows authentication. Type: string (or Expression with resultType string).
 * @property password Password for windows authentication.
 * @property userName UseName for windows authentication. Type: string (or Expression with resultType string).
 */
public data class SSISAccessCredentialResponse(
    public val domain: Any,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>,
    public val userName: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISAccessCredentialResponse):
            SSISAccessCredentialResponse = SSISAccessCredentialResponse(
            domain = javaType.domain(),
            password = javaType.password().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            userName = javaType.userName(),
        )
    }
}
