@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * SSIS package execution credential.
 * @property domain Domain for windows authentication. Type: string (or Expression with resultType string).
 * @property password Password for windows authentication.
 * @property userName UseName for windows authentication. Type: string (or Expression with resultType string).
 */
public data class SSISExecutionCredentialResponse(
    public val domain: Any,
    public val password: SecureStringResponse,
    public val userName: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISExecutionCredentialResponse):
            SSISExecutionCredentialResponse = SSISExecutionCredentialResponse(
            domain = javaType.domain(),
            password = javaType.password().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
            }),
            userName = javaType.userName(),
        )
    }
}
