@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SSIS package location.
 * @property accessCredential The package access credential.
 * @property childPackages The embedded child package list.
 * @property configurationAccessCredential The configuration file access credential.
 * @property configurationPath The configuration file of the package execution. Type: string (or Expression with resultType string).
 * @property packageContent The embedded package content. Type: string (or Expression with resultType string).
 * @property packageLastModifiedDate The embedded package last modified date.
 * @property packageName The package name.
 * @property packagePassword Password of the package.
 * @property packagePath The SSIS package path. Type: string (or Expression with resultType string).
 * @property type The type of SSIS package location.
 */
public data class SSISPackageLocationResponse(
    public val accessCredential: SSISAccessCredentialResponse? = null,
    public val childPackages: List<SSISChildPackageResponse>? = null,
    public val configurationAccessCredential: SSISAccessCredentialResponse? = null,
    public val configurationPath: Any? = null,
    public val packageContent: Any? = null,
    public val packageLastModifiedDate: String? = null,
    public val packageName: String? = null,
    public val packagePassword: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val packagePath: Any? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISPackageLocationResponse):
            SSISPackageLocationResponse = SSISPackageLocationResponse(
            accessCredential = javaType.accessCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISAccessCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            childPackages = javaType.childPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISChildPackageResponse.Companion.toKotlin(args0)
                })
            }),
            configurationAccessCredential = javaType.configurationAccessCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISAccessCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurationPath = javaType.configurationPath().map({ args0 -> args0 }).orElse(null),
            packageContent = javaType.packageContent().map({ args0 -> args0 }).orElse(null),
            packageLastModifiedDate = javaType.packageLastModifiedDate().map({ args0 -> args0 }).orElse(null),
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            packagePassword = javaType.packagePassword().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            packagePath = javaType.packagePath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
