@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity Salesforce Service Cloud V2 source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property includeDeletedObjects This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property sOQLQuery Database query. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'SalesforceServiceCloudV2Source'.
 */
public data class SalesforceServiceCloudV2SourceResponse(
    public val additionalColumns: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val includeDeletedObjects: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val sOQLQuery: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SalesforceServiceCloudV2SourceResponse):
            SalesforceServiceCloudV2SourceResponse = SalesforceServiceCloudV2SourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            includeDeletedObjects = javaType.includeDeletedObjects().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            sOQLQuery = javaType.sOQLQuery().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
