@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that creates pipeline runs periodically, on schedule.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property pipelines Pipelines that need to be started.
 * @property recurrence Recurrence schedule configuration.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property type Trigger type.
 * Expected value is 'ScheduleTrigger'.
 */
public data class ScheduleTriggerResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val pipelines: List<TriggerPipelineReferenceResponse>? = null,
    public val recurrence: ScheduleTriggerRecurrenceResponse,
    public val runtimeState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScheduleTriggerResponse):
            ScheduleTriggerResponse = ScheduleTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            recurrence = javaType.recurrence().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ScheduleTriggerRecurrenceResponse.Companion.toKotlin(args0)
            }),
            runtimeState = javaType.runtimeState(),
            type = javaType.type(),
        )
    }
}
