@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Self-hosted integration runtime.
 * @property description Integration runtime description.
 * @property linkedInfo The base definition of a linked integration runtime.
 * @property selfContainedInteractiveAuthoringEnabled An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
 * @property type The type of integration runtime.
 * Expected value is 'SelfHosted'.
 */
public data class SelfHostedIntegrationRuntimeResponse(
    public val description: String? = null,
    public val linkedInfo:
    Either<LinkedIntegrationRuntimeKeyAuthorizationResponse, LinkedIntegrationRuntimeRbacAuthorizationResponse>? =
        null,
    public val selfContainedInteractiveAuthoringEnabled: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SelfHostedIntegrationRuntimeResponse):
            SelfHostedIntegrationRuntimeResponse = SelfHostedIntegrationRuntimeResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            linkedInfo = javaType.linkedInfo().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedIntegrationRuntimeKeyAuthorizationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedIntegrationRuntimeRbacAuthorizationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            selfContainedInteractiveAuthoringEnabled = javaType.selfContainedInteractiveAuthoringEnabled().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
