@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Service principal credential.
 * @property annotations List of tags that can be used for describing the Credential.
 * @property description Credential description.
 * @property servicePrincipalId The app ID of the service principal used to authenticate
 * @property servicePrincipalKey The key of the service principal used to authenticate.
 * @property tenant The ID of the tenant to which the service principal belongs
 * @property type Type of credential.
 * Expected value is 'ServicePrincipal'.
 */
public data class ServicePrincipalCredentialResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey: AzureKeyVaultSecretReferenceResponse? = null,
    public val tenant: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ServicePrincipalCredentialResponse):
            ServicePrincipalCredentialResponse = ServicePrincipalCredentialResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
