@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Snowflake export command settings.
 * @property additionalCopyOptions Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE_FORMAT": "MM/DD/YYYY", "TIME_FORMAT": "'HH24:MI:SS.FF'" }
 * @property additionalFormatOptions Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalFormatOptions": { "OVERWRITE": "TRUE", "MAX_FILE_SIZE": "'FALSE'" }
 * @property type The export setting type.
 * Expected value is 'SnowflakeExportCopyCommand'.
 */
public data class SnowflakeExportCopyCommandResponse(
    public val additionalCopyOptions: Map<String, Any>? = null,
    public val additionalFormatOptions: Map<String, Any>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SnowflakeExportCopyCommandResponse):
            SnowflakeExportCopyCommandResponse = SnowflakeExportCopyCommandResponse(
            additionalCopyOptions = javaType.additionalCopyOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            additionalFormatOptions = javaType.additionalFormatOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            type = javaType.type(),
        )
    }
}
