@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for TeamDesk.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property apiToken The api token for the TeamDesk source.
 * @property authenticationType The authentication type to use.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The password of the TeamDesk source.
 * @property type Type of linked service.
 * Expected value is 'TeamDesk'.
 * @property url The url to connect TeamDesk source. Type: string (or Expression with resultType string).
 * @property userName The username of the TeamDesk source. Type: string (or Expression with resultType string).
 */
public data class TeamDeskLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val apiToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val authenticationType: String,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val url: Any,
    public val userName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TeamDeskLinkedServiceResponse):
            TeamDeskLinkedServiceResponse = TeamDeskLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            apiToken = javaType.apiToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            authenticationType = javaType.authenticationType(),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
