@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Definition of a single variable for a Pipeline.
 * @property defaultValue Default value of variable.
 * @property type Variable type.
 */
public data class VariableSpecificationResponse(
    public val defaultValue: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.VariableSpecificationResponse):
            VariableSpecificationResponse = VariableSpecificationResponse(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
