@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Web activity.
 * @property authentication Authentication method used for calling the endpoint.
 * @property body Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property datasets List of datasets passed to web endpoint.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property disableCertValidation When set to true, Certificate validation will be disabled.
 * @property headers Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
 * @property httpRequestTimeout Timeout for the HTTP request to get a response. Format is in TimeSpan (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00 (1 minute). The range is from 1 to 10 minutes
 * @property linkedServiceName Linked service reference.
 * @property linkedServices List of linked services passed to web endpoint.
 * @property method Rest API method for target endpoint.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property turnOffAsync Option to disable invoking HTTP GET on location given in response header of a HTTP 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false then continues to invoke HTTP GET call on location given in http response headers.
 * @property type Type of activity.
 * Expected value is 'WebActivity'.
 * @property url Web activity target endpoint and path. Type: string (or Expression with resultType string).
 * @property userProperties Activity user properties.
 */
public data class WebActivityResponse(
    public val authentication: WebActivityAuthenticationResponse? = null,
    public val body: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val datasets: List<DatasetReferenceResponse>? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val disableCertValidation: Boolean? = null,
    public val headers: Map<String, Any>? = null,
    public val httpRequestTimeout: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val linkedServices: List<LinkedServiceReferenceResponse>? = null,
    public val method: String,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val state: String? = null,
    public val turnOffAsync: Boolean? = null,
    public val type: String,
    public val url: Any,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebActivityResponse):
            WebActivityResponse = WebActivityResponse(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.WebActivityAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            body = javaType.body().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            datasets = javaType.datasets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disableCertValidation = javaType.disableCertValidation().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            httpRequestTimeout = javaType.httpRequestTimeout().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServices = javaType.linkedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            method = javaType.method(),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            turnOffAsync = javaType.turnOffAsync().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
