@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin

import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.ComputePolicyResponse
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.DataLakeStoreAccountInformationResponse
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.FirewallRuleResponse
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.HiveMetastoreResponse
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.StorageAccountInformationResponse
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.VirtualNetworkRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.ComputePolicyResponse.Companion.toKotlin as computePolicyResponseToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.DataLakeStoreAccountInformationResponse.Companion.toKotlin as dataLakeStoreAccountInformationResponseToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin as firewallRuleResponseToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.HiveMetastoreResponse.Companion.toKotlin as hiveMetastoreResponseToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.StorageAccountInformationResponse.Companion.toKotlin as storageAccountInformationResponseToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin as virtualNetworkRuleResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource =
            com.pulumi.azurenative.datalakeanalytics.Account(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Account(builtJavaResource)
    }
}

/**
 * A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2016-11-01.
 * Other available API versions: 2015-10-01-preview.
 * ## Example Usage
 * ### Creates the specified Data Lake Analytics account. This supplies the user with computation services for Data Lake Analytics workloads.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.DataLakeAnalytics.Account("account", new()
 *     {
 *         AccountName = "contosoadla",
 *         ComputePolicies = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.CreateComputePolicyWithAccountParametersArgs
 *             {
 *                 MaxDegreeOfParallelismPerJob = 1,
 *                 MinPriorityPerJob = 1,
 *                 Name = "test_policy",
 *                 ObjectId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
 *                 ObjectType = AzureNative.DataLakeAnalytics.AADObjectType.User,
 *             },
 *         },
 *         DataLakeStoreAccounts = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.AddDataLakeStoreWithAccountParametersArgs
 *             {
 *                 Name = "test_adls",
 *                 Suffix = "test_suffix",
 *             },
 *         },
 *         DefaultDataLakeStoreAccount = "test_adls",
 *         FirewallAllowAzureIps = AzureNative.DataLakeAnalytics.FirewallAllowAzureIpsState.Enabled,
 *         FirewallRules = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.CreateFirewallRuleWithAccountParametersArgs
 *             {
 *                 EndIpAddress = "2.2.2.2",
 *                 Name = "test_rule",
 *                 StartIpAddress = "1.1.1.1",
 *             },
 *         },
 *         FirewallState = AzureNative.DataLakeAnalytics.FirewallState.Enabled,
 *         Location = "eastus2",
 *         MaxDegreeOfParallelism = 30,
 *         MaxDegreeOfParallelismPerJob = 1,
 *         MaxJobCount = 3,
 *         MinPriorityPerJob = 1,
 *         NewTier = AzureNative.DataLakeAnalytics.TierType.Consumption,
 *         QueryStoreRetention = 30,
 *         ResourceGroupName = "contosorg",
 *         StorageAccounts = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.AddStorageAccountWithAccountParametersArgs
 *             {
 *                 AccessKey = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab346",
 *                 Name = "test_storage",
 *                 Suffix = "test_suffix",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "test_key", "test_value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakeanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakeanalytics.NewAccount(ctx, "account", &datalakeanalytics.AccountArgs{
 * 			AccountName: pulumi.String("contosoadla"),
 * 			ComputePolicies: datalakeanalytics.CreateComputePolicyWithAccountParametersArray{
 * 				&datalakeanalytics.CreateComputePolicyWithAccountParametersArgs{
 * 					MaxDegreeOfParallelismPerJob: pulumi.Int(1),
 * 					MinPriorityPerJob:            pulumi.Int(1),
 * 					Name:                         pulumi.String("test_policy"),
 * 					ObjectId:                     pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
 * 					ObjectType:                   pulumi.String(datalakeanalytics.AADObjectTypeUser),
 * 				},
 * 			},
 * 			DataLakeStoreAccounts: datalakeanalytics.AddDataLakeStoreWithAccountParametersArray{
 * 				&datalakeanalytics.AddDataLakeStoreWithAccountParametersArgs{
 * 					Name:   pulumi.String("test_adls"),
 * 					Suffix: pulumi.String("test_suffix"),
 * 				},
 * 			},
 * 			DefaultDataLakeStoreAccount: pulumi.String("test_adls"),
 * 			FirewallAllowAzureIps:       datalakeanalytics.FirewallAllowAzureIpsStateEnabled,
 * 			FirewallRules: datalakeanalytics.CreateFirewallRuleWithAccountParametersArray{
 * 				&datalakeanalytics.CreateFirewallRuleWithAccountParametersArgs{
 * 					EndIpAddress:   pulumi.String("2.2.2.2"),
 * 					Name:           pulumi.String("test_rule"),
 * 					StartIpAddress: pulumi.String("1.1.1.1"),
 * 				},
 * 			},
 * 			FirewallState:                datalakeanalytics.FirewallStateEnabled,
 * 			Location:                     pulumi.String("eastus2"),
 * 			MaxDegreeOfParallelism:       pulumi.Int(30),
 * 			MaxDegreeOfParallelismPerJob: pulumi.Int(1),
 * 			MaxJobCount:                  pulumi.Int(3),
 * 			MinPriorityPerJob:            pulumi.Int(1),
 * 			NewTier:                      datalakeanalytics.TierTypeConsumption,
 * 			QueryStoreRetention:          pulumi.Int(30),
 * 			ResourceGroupName:            pulumi.String("contosorg"),
 * 			StorageAccounts: datalakeanalytics.AddStorageAccountWithAccountParametersArray{
 * 				&datalakeanalytics.AddStorageAccountWithAccountParametersArgs{
 * 					AccessKey: pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab346"),
 * 					Name:      pulumi.String("test_storage"),
 * 					Suffix:    pulumi.String("test_suffix"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test_key": pulumi.String("test_value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakeanalytics.Account;
 * import com.pulumi.azurenative.datalakeanalytics.AccountArgs;
 * import com.pulumi.azurenative.datalakeanalytics.inputs.CreateComputePolicyWithAccountParametersArgs;
 * import com.pulumi.azurenative.datalakeanalytics.inputs.AddDataLakeStoreWithAccountParametersArgs;
 * import com.pulumi.azurenative.datalakeanalytics.inputs.CreateFirewallRuleWithAccountParametersArgs;
 * import com.pulumi.azurenative.datalakeanalytics.inputs.AddStorageAccountWithAccountParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("contosoadla")
 *             .computePolicies(CreateComputePolicyWithAccountParametersArgs.builder()
 *                 .maxDegreeOfParallelismPerJob(1)
 *                 .minPriorityPerJob(1)
 *                 .name("test_policy")
 *                 .objectId("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345")
 *                 .objectType("User")
 *                 .build())
 *             .dataLakeStoreAccounts(AddDataLakeStoreWithAccountParametersArgs.builder()
 *                 .name("test_adls")
 *                 .suffix("test_suffix")
 *                 .build())
 *             .defaultDataLakeStoreAccount("test_adls")
 *             .firewallAllowAzureIps("Enabled")
 *             .firewallRules(CreateFirewallRuleWithAccountParametersArgs.builder()
 *                 .endIpAddress("2.2.2.2")
 *                 .name("test_rule")
 *                 .startIpAddress("1.1.1.1")
 *                 .build())
 *             .firewallState("Enabled")
 *             .location("eastus2")
 *             .maxDegreeOfParallelism(30)
 *             .maxDegreeOfParallelismPerJob(1)
 *             .maxJobCount(3)
 *             .minPriorityPerJob(1)
 *             .newTier("Consumption")
 *             .queryStoreRetention(30)
 *             .resourceGroupName("contosorg")
 *             .storageAccounts(AddStorageAccountWithAccountParametersArgs.builder()
 *                 .accessKey("34adfa4f-cedf-4dc0-ba29-b6d1a69ab346")
 *                 .name("test_storage")
 *                 .suffix("test_suffix")
 *                 .build())
 *             .tags(Map.of("test_key", "test_value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakeanalytics:Account test_account /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakeanalytics.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The unique identifier associated with this Data Lake Analytics account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The list of compute policies associated with this account.
     */
    public val computePolicies: Output<List<ComputePolicyResponse>>
        get() = javaResource.computePolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> computePolicyResponseToKotlin(args0) })
            })
        })

    /**
     * The account creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The commitment tier in use for the current month.
     */
    public val currentTier: Output<String>
        get() = javaResource.currentTier().applyValue({ args0 -> args0 })

    /**
     * The list of Data Lake Store accounts associated with this account.
     */
    public val dataLakeStoreAccounts: Output<List<DataLakeStoreAccountInformationResponse>>
        get() = javaResource.dataLakeStoreAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataLakeStoreAccountInformationResponseToKotlin(args0) })
            })
        })

    /**
     * The current state of the DebugDataAccessLevel for this account.
     */
    public val debugDataAccessLevel: Output<String>
        get() = javaResource.debugDataAccessLevel().applyValue({ args0 -> args0 })

    /**
     * The default Data Lake Store account associated with this account.
     */
    public val defaultDataLakeStoreAccount: Output<String>
        get() = javaResource.defaultDataLakeStoreAccount().applyValue({ args0 -> args0 })

    /**
     * The type of the default Data Lake Store account associated with this account.
     */
    public val defaultDataLakeStoreAccountType: Output<String>
        get() = javaResource.defaultDataLakeStoreAccountType().applyValue({ args0 -> args0 })

    /**
     * The full CName endpoint for this account.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    public val firewallAllowAzureIps: Output<String>?
        get() = javaResource.firewallAllowAzureIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of firewall rules associated with this account.
     */
    public val firewallRules: Output<List<FirewallRuleResponse>>
        get() = javaResource.firewallRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallRuleResponseToKotlin(args0) })
            })
        })

    /**
     * The current state of the IP address firewall for this account.
     */
    public val firewallState: Output<String>?
        get() = javaResource.firewallState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of hiveMetastores associated with this account.
     */
    public val hiveMetastores: Output<List<HiveMetastoreResponse>>
        get() = javaResource.hiveMetastores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hiveMetastoreResponseToKotlin(args0) })
            })
        })

    /**
     * The account last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The maximum supported active jobs under the account at the same time.
     */
    public val maxActiveJobCountPerUser: Output<Int>
        get() = javaResource.maxActiveJobCountPerUser().applyValue({ args0 -> args0 })

    /**
     * The maximum supported degree of parallelism for this account.
     */
    public val maxDegreeOfParallelism: Output<Int>?
        get() = javaResource.maxDegreeOfParallelism().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum supported degree of parallelism per job for this account.
     */
    public val maxDegreeOfParallelismPerJob: Output<Int>?
        get() = javaResource.maxDegreeOfParallelismPerJob().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum supported jobs running under the account at the same time.
     */
    public val maxJobCount: Output<Int>?
        get() = javaResource.maxJobCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum supported active jobs under the account at the same time.
     */
    public val maxJobRunningTimeInMin: Output<Int>
        get() = javaResource.maxJobRunningTimeInMin().applyValue({ args0 -> args0 })

    /**
     * The maximum supported jobs queued under the account at the same time.
     */
    public val maxQueuedJobCountPerUser: Output<Int>
        get() = javaResource.maxQueuedJobCountPerUser().applyValue({ args0 -> args0 })

    /**
     * The minimum supported priority per job for this account.
     */
    public val minPriorityPerJob: Output<Int>
        get() = javaResource.minPriorityPerJob().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The commitment tier for the next month.
     */
    public val newTier: Output<String>?
        get() = javaResource.newTier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning status of the Data Lake Analytics account.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of Data Lake Store accounts associated with this account.
     */
    public val publicDataLakeStoreAccounts: Output<List<DataLakeStoreAccountInformationResponse>>?
        get() = javaResource.publicDataLakeStoreAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dataLakeStoreAccountInformationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The number of days that job metadata is retained.
     */
    public val queryStoreRetention: Output<Int>?
        get() = javaResource.queryStoreRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the Data Lake Analytics account.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The list of Azure Blob Storage accounts associated with this account.
     */
    public val storageAccounts: Output<List<StorageAccountInformationResponse>>
        get() = javaResource.storageAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageAccountInformationResponseToKotlin(args0) })
            })
        })

    /**
     * The system defined maximum supported degree of parallelism for this account, which restricts the maximum value of parallelism the user can set for the account.
     */
    public val systemMaxDegreeOfParallelism: Output<Int>
        get() = javaResource.systemMaxDegreeOfParallelism().applyValue({ args0 -> args0 })

    /**
     * The system defined maximum supported jobs running under the account at the same time, which restricts the maximum number of running jobs the user can set for the account.
     */
    public val systemMaxJobCount: Output<Int>
        get() = javaResource.systemMaxJobCount().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtualNetwork rules associated with this account.
     */
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleResponse>>
        get() = javaResource.virtualNetworkRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkRuleResponseToKotlin(args0) })
            })
        })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakeanalytics.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.datalakeanalytics.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
