@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.AddDataLakeStoreWithAccountParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to add a new Data Lake Store account while creating a new Data Lake Analytics account.
 * @property name The unique name of the Data Lake Store account to add.
 * @property suffix The optional suffix for the Data Lake Store account.
 */
public data class AddDataLakeStoreWithAccountParametersArgs(
    public val name: Output<String>,
    public val suffix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.AddDataLakeStoreWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakeanalytics.inputs.AddDataLakeStoreWithAccountParametersArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.AddDataLakeStoreWithAccountParametersArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddDataLakeStoreWithAccountParametersArgs].
 */
@PulumiTagMarker
public class AddDataLakeStoreWithAccountParametersArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value The unique name of the Data Lake Store account to add.
     */
    @JvmName("ykyhafjlbesfemyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The optional suffix for the Data Lake Store account.
     */
    @JvmName("cgaemhqmpgtjmjqb")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value The unique name of the Data Lake Store account to add.
     */
    @JvmName("rpmucgtweejxkyha")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The optional suffix for the Data Lake Store account.
     */
    @JvmName("bmtsnijqpndxjuua")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): AddDataLakeStoreWithAccountParametersArgs =
        AddDataLakeStoreWithAccountParametersArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            suffix = suffix,
        )
}
