@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Storage account information.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property suffix The optional suffix for the storage account.
 * @property type The resource type.
 */
public data class StorageAccountInformationResponse(
    public val id: String,
    public val name: String,
    public val suffix: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.StorageAccountInformationResponse):
            StorageAccountInformationResponse = StorageAccountInformationResponse(
            id = javaType.id(),
            name = javaType.name(),
            suffix = javaType.suffix(),
            type = javaType.type(),
        )
    }
}
