@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionConfigResponse
import com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionIdentityResponse
import com.pulumi.azurenative.datalakestore.kotlin.outputs.FirewallRuleResponse
import com.pulumi.azurenative.datalakestore.kotlin.outputs.TrustedIdProviderResponse
import com.pulumi.azurenative.datalakestore.kotlin.outputs.VirtualNetworkRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionConfigResponse.Companion.toKotlin as encryptionConfigResponseToKotlin
import com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionIdentityResponse.Companion.toKotlin as encryptionIdentityResponseToKotlin
import com.pulumi.azurenative.datalakestore.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin as firewallRuleResponseToKotlin
import com.pulumi.azurenative.datalakestore.kotlin.outputs.TrustedIdProviderResponse.Companion.toKotlin as trustedIdProviderResponseToKotlin
import com.pulumi.azurenative.datalakestore.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin as virtualNetworkRuleResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.azurenative.datalakestore.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Data Lake Store account information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates the specified Data Lake Store account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.DataLakeStore.Account("account", new()
 *     {
 *         AccountName = "contosoadla",
 *         DefaultGroup = "test_default_group",
 *         EncryptionConfig = new AzureNative.DataLakeStore.Inputs.EncryptionConfigArgs
 *         {
 *             KeyVaultMetaInfo = new AzureNative.DataLakeStore.Inputs.KeyVaultMetaInfoArgs
 *             {
 *                 EncryptionKeyName = "test_encryption_key_name",
 *                 EncryptionKeyVersion = "encryption_key_version",
 *                 KeyVaultResourceId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
 *             },
 *             Type = AzureNative.DataLakeStore.EncryptionConfigType.UserManaged,
 *         },
 *         EncryptionState = AzureNative.DataLakeStore.EncryptionState.Enabled,
 *         FirewallAllowAzureIps = AzureNative.DataLakeStore.FirewallAllowAzureIpsState.Enabled,
 *         FirewallRules = new[]
 *         {
 *             new AzureNative.DataLakeStore.Inputs.CreateFirewallRuleWithAccountParametersArgs
 *             {
 *                 EndIpAddress = "2.2.2.2",
 *                 Name = "test_rule",
 *                 StartIpAddress = "1.1.1.1",
 *             },
 *         },
 *         FirewallState = AzureNative.DataLakeStore.FirewallState.Enabled,
 *         Identity = new AzureNative.DataLakeStore.Inputs.EncryptionIdentityArgs
 *         {
 *             Type = AzureNative.DataLakeStore.EncryptionIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2",
 *         NewTier = AzureNative.DataLakeStore.TierType.Consumption,
 *         ResourceGroupName = "contosorg",
 *         Tags =
 *         {
 *             { "test_key", "test_value" },
 *         },
 *         TrustedIdProviderState = AzureNative.DataLakeStore.TrustedIdProviderState.Enabled,
 *         TrustedIdProviders = new[]
 *         {
 *             new AzureNative.DataLakeStore.Inputs.CreateTrustedIdProviderWithAccountParametersArgs
 *             {
 *                 IdProvider = "https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1",
 *                 Name = "test_trusted_id_provider_name",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewAccount(ctx, "account", &datalakestore.AccountArgs{
 * 			AccountName:  pulumi.String("contosoadla"),
 * 			DefaultGroup: pulumi.String("test_default_group"),
 * 			EncryptionConfig: &datalakestore.EncryptionConfigArgs{
 * 				KeyVaultMetaInfo: &datalakestore.KeyVaultMetaInfoArgs{
 * 					EncryptionKeyName:    pulumi.String("test_encryption_key_name"),
 * 					EncryptionKeyVersion: pulumi.String("encryption_key_version"),
 * 					KeyVaultResourceId:   pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
 * 				},
 * 				Type: datalakestore.EncryptionConfigTypeUserManaged,
 * 			},
 * 			EncryptionState:       datalakestore.EncryptionStateEnabled,
 * 			FirewallAllowAzureIps: datalakestore.FirewallAllowAzureIpsStateEnabled,
 * 			FirewallRules: datalakestore.CreateFirewallRuleWithAccountParametersArray{
 * 				&datalakestore.CreateFirewallRuleWithAccountParametersArgs{
 * 					EndIpAddress:   pulumi.String("2.2.2.2"),
 * 					Name:           pulumi.String("test_rule"),
 * 					StartIpAddress: pulumi.String("1.1.1.1"),
 * 				},
 * 			},
 * 			FirewallState: datalakestore.FirewallStateEnabled,
 * 			Identity: &datalakestore.EncryptionIdentityArgs{
 * 				Type: datalakestore.EncryptionIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			NewTier:           datalakestore.TierTypeConsumption,
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tags: pulumi.StringMap{
 * 				"test_key": pulumi.String("test_value"),
 * 			},
 * 			TrustedIdProviderState: datalakestore.TrustedIdProviderStateEnabled,
 * 			TrustedIdProviders: datalakestore.CreateTrustedIdProviderWithAccountParametersArray{
 * 				&datalakestore.CreateTrustedIdProviderWithAccountParametersArgs{
 * 					IdProvider: pulumi.String("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1"),
 * 					Name:       pulumi.String("test_trusted_id_provider_name"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.Account;
 * import com.pulumi.azurenative.datalakestore.AccountArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.CreateFirewallRuleWithAccountParametersArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("contosoadla")
 *             .defaultGroup("test_default_group")
 *             .encryptionConfig(EncryptionConfigArgs.builder()
 *                 .keyVaultMetaInfo(KeyVaultMetaInfoArgs.builder()
 *                     .encryptionKeyName("test_encryption_key_name")
 *                     .encryptionKeyVersion("encryption_key_version")
 *                     .keyVaultResourceId("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345")
 *                     .build())
 *                 .type("UserManaged")
 *                 .build())
 *             .encryptionState("Enabled")
 *             .firewallAllowAzureIps("Enabled")
 *             .firewallRules(CreateFirewallRuleWithAccountParametersArgs.builder()
 *                 .endIpAddress("2.2.2.2")
 *                 .name("test_rule")
 *                 .startIpAddress("1.1.1.1")
 *                 .build())
 *             .firewallState("Enabled")
 *             .identity(EncryptionIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus2")
 *             .newTier("Consumption")
 *             .resourceGroupName("contosorg")
 *             .tags(Map.of("test_key", "test_value"))
 *             .trustedIdProviderState("Enabled")
 *             .trustedIdProviders(CreateTrustedIdProviderWithAccountParametersArgs.builder()
 *                 .idProvider("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1")
 *                 .name("test_trusted_id_provider_name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:Account contosoadla /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakestore.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The unique identifier associated with this Data Lake Store account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The account creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The commitment tier in use for the current month.
     */
    public val currentTier: Output<String>
        get() = javaResource.currentTier().applyValue({ args0 -> args0 })

    /**
     * The default owner group for all new folders and files created in the Data Lake Store account.
     */
    public val defaultGroup: Output<String>
        get() = javaResource.defaultGroup().applyValue({ args0 -> args0 })

    /**
     * The Key Vault encryption configuration.
     */
    public val encryptionConfig: Output<EncryptionConfigResponse>
        get() = javaResource.encryptionConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                encryptionConfigResponseToKotlin(args0)
            })
        })

    /**
     * The current state of encryption provisioning for this Data Lake Store account.
     */
    public val encryptionProvisioningState: Output<String>
        get() = javaResource.encryptionProvisioningState().applyValue({ args0 -> args0 })

    /**
     * The current state of encryption for this Data Lake Store account.
     */
    public val encryptionState: Output<String>
        get() = javaResource.encryptionState().applyValue({ args0 -> args0 })

    /**
     * The full CName endpoint for this account.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    public val firewallAllowAzureIps: Output<String>
        get() = javaResource.firewallAllowAzureIps().applyValue({ args0 -> args0 })

    /**
     * The list of firewall rules associated with this Data Lake Store account.
     */
    public val firewallRules: Output<List<FirewallRuleResponse>>
        get() = javaResource.firewallRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallRuleResponseToKotlin(args0) })
            })
        })

    /**
     * The current state of the IP address firewall for this Data Lake Store account.
     */
    public val firewallState: Output<String>
        get() = javaResource.firewallState().applyValue({ args0 -> args0 })

    /**
     * The Key Vault encryption identity, if any.
     */
    public val identity: Output<EncryptionIdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                encryptionIdentityResponseToKotlin(args0)
            })
        })

    /**
     * The account last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The commitment tier to use for next month.
     */
    public val newTier: Output<String>
        get() = javaResource.newTier().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the Data Lake Store account.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The state of the Data Lake Store account.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current state of the trusted identity provider feature for this Data Lake Store account.
     */
    public val trustedIdProviderState: Output<String>
        get() = javaResource.trustedIdProviderState().applyValue({ args0 -> args0 })

    /**
     * The list of trusted identity providers associated with this Data Lake Store account.
     */
    public val trustedIdProviders: Output<List<TrustedIdProviderResponse>>
        get() = javaResource.trustedIdProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trustedIdProviderResponseToKotlin(args0) })
            })
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtual network rules associated with this Data Lake Store account.
     */
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleResponse>>
        get() = javaResource.virtualNetworkRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkRuleResponseToKotlin(args0) })
            })
        })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakestore.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.datalakestore.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
