@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data Lake Store trusted identity provider information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trustedIdProvider = new AzureNative.DataLakeStore.TrustedIdProvider("trustedIdProvider", new()
 *     {
 *         AccountName = "contosoadla",
 *         IdProvider = "https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1",
 *         ResourceGroupName = "contosorg",
 *         TrustedIdProviderName = "test_trusted_id_provider_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewTrustedIdProvider(ctx, "trustedIdProvider", &datalakestore.TrustedIdProviderArgs{
 * 			AccountName:           pulumi.String("contosoadla"),
 * 			IdProvider:            pulumi.String("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1"),
 * 			ResourceGroupName:     pulumi.String("contosorg"),
 * 			TrustedIdProviderName: pulumi.String("test_trusted_id_provider_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.TrustedIdProvider;
 * import com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trustedIdProvider = new TrustedIdProvider("trustedIdProvider", TrustedIdProviderArgs.builder()
 *             .accountName("contosoadla")
 *             .idProvider("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1")
 *             .resourceGroupName("contosorg")
 *             .trustedIdProviderName("test_trusted_id_provider_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:TrustedIdProvider test_trusted_id_provider_name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}
 * ```
 * @property accountName The name of the Data Lake Store account.
 * @property idProvider The URL of this trusted identity provider.
 * @property resourceGroupName The name of the Azure resource group.
 * @property trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
 */
public data class TrustedIdProviderArgs(
    public val accountName: Output<String>? = null,
    public val idProvider: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val trustedIdProviderName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs =
        com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .idProvider(idProvider?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .trustedIdProviderName(trustedIdProviderName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustedIdProviderArgs].
 */
@PulumiTagMarker
public class TrustedIdProviderArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var idProvider: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var trustedIdProviderName: Output<String>? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("pjbapvcnemgmrscw")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The URL of this trusted identity provider.
     */
    @JvmName("utenkwggqcreufyq")
    public suspend fun idProvider(`value`: Output<String>) {
        this.idProvider = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("enebisvdchkkrvqr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the trusted identity provider. This is used for differentiation of providers in the account.
     */
    @JvmName("wurqiorpsujmquab")
    public suspend fun trustedIdProviderName(`value`: Output<String>) {
        this.trustedIdProviderName = value
    }

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("djrglvvqjquadarf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The URL of this trusted identity provider.
     */
    @JvmName("yehafolmasjxdxrf")
    public suspend fun idProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idProvider = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("uqdbnqsiryosrpor")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the trusted identity provider. This is used for differentiation of providers in the account.
     */
    @JvmName("xigpwxlyyudirfbd")
    public suspend fun trustedIdProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedIdProviderName = mapped
    }

    internal fun build(): TrustedIdProviderArgs = TrustedIdProviderArgs(
        accountName = accountName,
        idProvider = idProvider,
        resourceGroupName = resourceGroupName,
        trustedIdProviderName = trustedIdProviderName,
    )
}
