@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualNetworkRule].
 */
@PulumiTagMarker
public class VirtualNetworkRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkRuleArgs = VirtualNetworkRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetworkRule {
        val builtJavaResource =
            com.pulumi.azurenative.datalakestore.VirtualNetworkRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkRule(builtJavaResource)
    }
}

/**
 * Data Lake Store virtual network rule information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified virtual network rule. During update, the virtual network rule with the specified name will be replaced with this new virtual network rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRule = new AzureNative.DataLakeStore.VirtualNetworkRule("virtualNetworkRule", new()
 *     {
 *         AccountName = "contosoadla",
 *         ResourceGroupName = "contosorg",
 *         SubnetId = "test_subnetId",
 *         VirtualNetworkRuleName = "test_virtual_network_rules_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewVirtualNetworkRule(ctx, "virtualNetworkRule", &datalakestore.VirtualNetworkRuleArgs{
 * 			AccountName:            pulumi.String("contosoadla"),
 * 			ResourceGroupName:      pulumi.String("contosorg"),
 * 			SubnetId:               pulumi.String("test_subnetId"),
 * 			VirtualNetworkRuleName: pulumi.String("test_virtual_network_rules_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.VirtualNetworkRule;
 * import com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRule = new VirtualNetworkRule("virtualNetworkRule", VirtualNetworkRuleArgs.builder()
 *             .accountName("contosoadla")
 *             .resourceGroupName("contosorg")
 *             .subnetId("test_subnetId")
 *             .virtualNetworkRuleName("test_virtual_network_rules_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:VirtualNetworkRule test_virtual_network_rules_name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}
 * ```
 */
public class VirtualNetworkRule internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakestore.VirtualNetworkRule,
) : KotlinCustomResource(javaResource, VirtualNetworkRuleMapper) {
    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource identifier for the subnet.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualNetworkRuleMapper : ResourceMapper<VirtualNetworkRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakestore.VirtualNetworkRule::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkRule = VirtualNetworkRule(
        javaResource as
            com.pulumi.azurenative.datalakestore.VirtualNetworkRule,
    )
}

/**
 * @see [VirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkRule].
 */
public suspend fun virtualNetworkRule(
    name: String,
    block: suspend VirtualNetworkRuleResourceBuilder.() -> Unit,
): VirtualNetworkRule {
    val builder = VirtualNetworkRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkRule(name: String): VirtualNetworkRule {
    val builder = VirtualNetworkRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
