@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The commitment tier to use for next month.
 */
public enum class TierType(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.TierType,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.TierType> {
    Consumption(com.pulumi.azurenative.datalakestore.enums.TierType.Consumption),
    Commitment_1TB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_1TB),
    Commitment_10TB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_10TB),
    Commitment_100TB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_100TB),
    Commitment_500TB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_500TB),
    Commitment_1PB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_1PB),
    Commitment_5PB(com.pulumi.azurenative.datalakestore.enums.TierType.Commitment_5PB),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.TierType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.TierType): TierType =
            TierType.values().first { it.javaValue == javaType }
    }
}
